//"""MLBERTMGR CPP programmer's guide"""
//__version__     = "1.7.4"
//__author__      = "MultilaneInc <support@multilaneinc.com>"
//__date__        = '2025-11-06'

#include "../../libbertacquisitionmanager/x64/BertAcquisitionManagerLib.h"
#include <iomanip>      // std::setprecision
#include <iostream>
#include <sstream>
#include <fstream>

#ifndef _WIN32
#include <string.h>
#include <unistd.h>
void _sleep(double time) {
	usleep((int)(time * 1e3));
}
#endif

using namespace std;


int main()
{

	// create instance
	mlbertmgr* MLBERT = mlbertmgr_createInstance();
	const int NB_CHANNELS = 8;
	// CHANNEL 
	int CHANNEL = 0;


	char* ADDRESS = "172.16.230.53";
	// Connects to device before initializing the instance
	cout << "mlbertmgr_openConnection: " << mlbertmgr_openConnection(MLBERT, ADDRESS) << endl;

	// Initialises instance 
	InstanceParams T_PARAMS;

	char SAVE_CONFIG[] = "";
	strncpy(T_PARAMS.saveConfig, SAVE_CONFIG, MAX_ADDR_LEN);
	strncpy(T_PARAMS.saveBathtub, "", MAX_ADDR_LEN);
	strncpy(T_PARAMS.saveEye, "", MAX_ADDR_LEN);
	T_PARAMS.saveEyeEnable = false;
	T_PARAMS.saveBathtubEnable = false;

	cout << "mlbertmgr_initializeInstance: " << mlbertmgr_initializeInstance(MLBERT, T_PARAMS) << endl;
	double linerate = 53.125;
	//cout << mlbertmgr_setLinerate79E(MLBERT, "C:\\Users\\jbitar\\AppData\\Roaming\\ThunderBERT\\172.16.230.23\\clk", &linerate, false);
	//
	//	ConfigurationSettings* configFromFile = new ConfigurationSettings();
	//	mlbertmgr_LoadConfigurationFromFile(MLBERT, "Full//Path//Config_172.16.230.28_20250219T110925.xml", configFromFile, true);
	//
	//	mlbertmgr_enableMonitor(MLBERT, false);  //  Turn off all monitor flags
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//test flow 1: Get Board information of any BERT
	//	Board_Info INFO;
	//	INFO.Bootloader_Flag = false;
	//
	//	cout << "mlbertmgr_getInfo status: " << mlbertmgr_getInfo(MLBERT, &INFO) << endl;
	//	cout << "Board Info: " << endl;
	//	cout << "\tBoardID: " << INFO.boardID << endl;
	//	cout << "\tHWRev: " << INFO.HWRev / 256 << "." << INFO.HWRev % 256 << endl;
	//	cout << "\tFWRev: " << INFO.FWRev / 256 << "." << INFO.FWRev % 256 << endl;
	//	cout << "\tSilabRev: " << INFO.SilabRev << endl;
	//	cout << "\tIPAddress: " << ((INFO.ipAddress >> 24) & 0xff) << '.' << (INFO.ipAddress >> 16 & 0xff) << '.' << (INFO.ipAddress >> 8 & 0xff) << '.' << (INFO.ipAddress & 0xff) << endl;
	//	cout << "\tMask: " << ((INFO.Mask >> 24) & 0xff) << '.' << (INFO.Mask >> 16 & 0xff) << '.' << (INFO.Mask >> 8 & 0xff) << '.' << (INFO.Mask & 0xff) << endl;
	//	cout << "\tGateway: " << ((INFO.Gateway >> 24) & 0xff) << '.' << (INFO.Gateway >> 16 & 0xff) << '.' << (INFO.Gateway >> 8 & 0xff) << '.' << (INFO.Gateway & 0xff) << endl;
	//	cout << "\tMAC: " << hex << ((INFO.MAC >> 40) & 0xff) << '-' << ((INFO.MAC >> 32) & 0xff) << '-' << ((INFO.MAC >> 24) & 0xff) << '-' << (INFO.MAC >> 16 & 0xff) << '-' << (INFO.MAC >> 8 & 0xff) << '-' << (INFO.MAC & 0xff) << endl;
	//	cout << "\tSN: ";
	//	for (int i = 0; i < 10; i++) {
	//		cout << hex << (ushort)INFO.SN[i] << " ";
	//	}
	//	cout << endl;
	//	cout << "\tBootloader_Flag: " << boolalpha << INFO.Bootloader_Flag << endl;
	//
	//	cout << "\tIsAdapterMode: " << INFO.isAdapterMode << endl;
	//	if (INFO.isAdapterMode == true) {
	//		cout << "\tadaptertype: " << ADAPTER_TYPE(INFO.adapterType) << endl;
	//
	//	}
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//test flow 2:Configure Clock Settings
	//	//Edit parameters for your instance
	//	//Configurations are cashed in the instrument's memory. Enable APPLYCONFIG for the last call of the flow to trigger the configuration of the instrument
	//	bool APPLYCONFIG = false;
	//	// Clock Source
	//	BERTMGR_CLOCKSOURCE CLOCKSOURCE = BERTMGR_INTERNALCLKSRC;
	//	// Clock Mode        
	//	BERTMGR_CLOCKMODE CLOCKMODE = BERTMGR_REFCLK;
	//	// Monitor Divider                 
	//	BERTMGR_MONITORDIVIDER DIVIDER = BERTMGR_MONITOR_DIV4;
	//	//  CDR Divider
	//	BERTMGR_CDRDIVIDER CDRDIVIDER = BERTMGR_CDR_DIV64;
	//
	//	// Set ClockSource               
	//	cout << "mlbertmgr_setClockSource status: " << mlbertmgr_setClockSource(MLBERT, CLOCKSOURCE, APPLYCONFIG) << endl;
	//
	//	// Set ClockMode
	//	cout << "mlbertmgr_setClockMode status: " << mlbertmgr_setClockMode(MLBERT, CLOCKMODE, APPLYCONFIG) << endl;
	//
	//	// Clock Divider
	//	// Set Monitor Divider
	//	cout << "mlbertmgr_setMonitorDivider status: " << mlbertmgr_setMonitorDivider(MLBERT, DIVIDER, APPLYCONFIG) << endl;
	//
	//	// set CDR Divider
	//	cout << "mlbertmgr_setCDRDivider status: " << mlbertmgr_setCDRDivider(MLBERT, CDRDIVIDER, APPLYCONFIG) << endl;
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//test flow 3: Configure LineRate, Coding and Amplitude Levels
	//	APPLYCONFIG = false;    // Configurations are cashed in the instrument's memory. Enable APPLYCONFIG for the last call of the flow to trigger the configuration of the instrument
	//
	//	// Eye Mode
	//	BERTMGR_SIGMODULATION EYEMODE = BERTMGR_NRZ;
	//
	//	// Taps Mode
	//	BERTMGR_TAPSMODE TAPSMODE = BERTMGR_3TAPS;
	//
	//	//FEC Mode
	//	BERTMGR_FECMODE FECMODE = BERTMGR_FECDISABLED;
	//	BERTMGR_FECPATTERN FECPATTRN = BERTMGR_FECPATTERN_DISABLED;
	//
	//	// Line Rate in Gb/s
	//	double LINERATE = 26.5625;
	//
	//	// Creates PatternConfig initial struct
	//	PatternConfig TXPATTERN;
	//	// Tx Pattern                                       
	//	TXPATTERN.pattern = BERTMGR_PRBS7;
	//	// Tx Invert 
	//	TXPATTERN.invert = false;
	//	//user defined
	//
	//
	//	// Creates PatternConfig initial struct
	//	PatternConfig RXPATTERN;
	//	// Rx Pattern  
	//	RXPATTERN.pattern = BERTMGR_PRBS7;
	//	// Rx Invert
	//	RXPATTERN.invert = false;
	//	/*
	//	//user defigned pattern
	//	//Tx Pattern
	//	TXPATTERN.pattern = BERTMGR_USERDEFINED;
	//	UserDefinedPatternDefinition USER_DEFIGNED_PATTERN ;
	//	USER_DEFIGNED_PATTERN.Pattern1.Pattern = 0XAAAAFFFF55550000;
	//	USER_DEFIGNED_PATTERN.Pattern1.Repetition = 1;
	//	USER_DEFIGNED_PATTERN.Pattern2.Pattern = 0XFFFF0000FFFF0000;
	//	USER_DEFIGNED_PATTERN.Pattern2.Repetition = 1;
	//	*/
	//	// Amplitude Level mV
	//	int AMPLITUDE = 200;
	//
	//	// Set Linerate
	//	cout << "mlbertmgr_setLinerate status: " << mlbertmgr_setLinerate(MLBERT, &LINERATE, APPLYCONFIG) << endl;
	//
	//	// set EyeMode
	//	cout << "mlbertmgr_setEyeMode status: " << mlbertmgr_setEyeMode(MLBERT, EYEMODE, APPLYCONFIG) << endl;
	//
	//	// Enable Gray Coding.Applied for PAM4 Eye Mode
	//	bool ENABLE = false;
	//	cout << "mlbertmgr_setGrayCoding status: " << mlbertmgr_setGrayCoding(MLBERT, ENABLE, APPLYCONFIG) << endl;
	//
	//	//Trigger the configuration of all the applied settings
	//	APPLYCONFIG = true;
	//	// Set Taps Mode
	//	cout << "mlbertmgr_setTapsMode status: " << mlbertmgr_setTapsMode(MLBERT, TAPSMODE, APPLYCONFIG) << endl;
	//
	//	// Set FEC Mode.Check The table of features for compatibility
	//	cout << "mlbertmgr_setFECMode status: " << mlbertmgr_setFECMode(MLBERT, FECMODE, FECPATTRN, APPLYCONFIG) << endl;
	//	
	//
	//
	//	for (int channel = 0; channel < NB_CHANNELS; channel++)
	//	{
	//		// Set Tx Pattern 
	//		cout << "mlbertmgr_setTxPattern status:  " << mlbertmgr_setTxPattern(MLBERT, channel, TXPATTERN, APPLYCONFIG) << endl;
	//
	//		// Set Rx Pattern 
	//		cout << "mlbertmgr_setRxPattern status: " << mlbertmgr_setRxPattern(MLBERT, channel, RXPATTERN, APPLYCONFIG) << endl;
	//
	//		//set User Defined Pattern 
	//		//cout <<"mlbertmgr_setUserDefinedPattern: "<< mlbertmgr_setUserDefinedPattern(MLBERT,channel, USER_DEFIGNED_PATTERN, APPLYCONFIG)<<endl;
	//
	//		//Set Calibrated Amplitude level. This function requires a calibrated Instrument
	//		//cout << "mlbertmgr_setAmplitude status:  " << mlbertmgr_setAmplitude(MLBERT, channel, AMPLITUDE, APPLYCONFIG) << endl;
	//	}
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//Test flow 4: Set advanced amplitude and equalization
	//
	//	   // Advanced Amplitude
	//	AdvancedAmplitude ADVANCEDAMPLITUDE;
	//	// Main Tap Value(-1000 to + 1000)
	//	ADVANCEDAMPLITUDE.mainTap = 350;
	//	// Post - emphasis Value(-1000 to + 1000)
	//	ADVANCEDAMPLITUDE.preEmphasis = -50;
	//	// Pre-emphasis Value (-1000 to +1000)
	//	ADVANCEDAMPLITUDE.postEmphasis = -50;
	//	// Inner Eye level(500 to 1500).Applied for PAM4
	//	ADVANCEDAMPLITUDE.innerLevel = 1000;
	//	// Outer Eye level (1500 to 2500). Applied to PAM4
	//	ADVANCEDAMPLITUDE.outerLevel = 2000;
	//	// Scaling Level Percentage (70, 80, 90, 100, 110, 120)
	//	ADVANCEDAMPLITUDE.scalingLevel = 80;
	//	// 7-Taps Mode
	//	for (int tap = 0; tap < 7; tap++) {
	//		ADVANCEDAMPLITUDE.advancedTaps[tap] = 0;
	//	}
	//	//APROX AMPLITUDE
	//	int APROXAMPLITUDE;
	//
	//	for (int channel = 0; channel < NB_CHANNELS; channel++)
	//	{
	//		//set advanced amplitude
	//		cout << "mlbertmgr_setAdvancedAmplitude status: " << mlbertmgr_setAdvancedAmplitude(MLBERT, channel, ADVANCEDAMPLITUDE, &APROXAMPLITUDE, APPLYCONFIG) << endl;
	//		cout << "APROX AMPLITUDE = " << dec << APROXAMPLITUDE << endl;
	//	}
	//
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	// Test Flow 5: Enable / Disable RX, TX
	//	for (int channel = 0; channel < NB_CHANNELS; channel++) {
	//		// Enable RX Channel
	//
	//		cout << "mlbertmgr_RxEnable: " << mlbertmgr_RxEnable(MLBERT, channel, true) << endl;
	//
	//		// Read RX Status                         
	//		bool ISENABLED = false;
	//		cout << "mlbertmgr_getRxStatus: " << mlbertmgr_getRxStatus(MLBERT, channel, &ISENABLED) << endl;
	//		cout << "Rx Status: " << ISENABLED << endl;
	//
	//		// Enable TX Channel
	//		cout << "mlbertmgr_TxEnable: " << mlbertmgr_TxEnable(MLBERT, channel, true) << endl;
	//
	//		// Read RX Status 
	//		ISENABLED = false;
	//		cout << "mlbertmgr_getTxStatus: " << mlbertmgr_getTxStatus(MLBERT, channel, &ISENABLED) << endl;
	//		cout << "Tx Status: " << ISENABLED << endl;
	//	}
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//Test flow 6: Get Active Configuration Settings
	//	ConfigurationSettings CONFIG;
	//	//std::numeric_limits<double>::max_digits10;
	//
	//	//cout << "mlbertmgr_getActiveConfig status: " << mlbertmgr_getActiveConfig(MLBERT, &CONFIG) << endl;
	//	//cout << "linerate: " << setprecision(10) << CONFIG.linerate << endl;
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//Test flow 7: Monitor function
	//
	//	// First method : Single read monitor flags.
	//	// Reads BERT Temperature flags
	//	BERTMGR_MONITOR_FLAGS SINGLEMONITORFLAG = BERTMGR_MONITOR_TEMPERATURE;
	//	//Temperature monitor requires 4 x ushort.Refer to the documentation for the required memory allocation per flag
	//	ushort SINGLE_MONITOR[NB_CHANNELS];
	//	// Enable Single Monitor Flag and sleep for 350 ms before starting monitor reading.
	//	// It is recommended to Enable the Monitor at the beginning of the main flow to avoid any settling time.
	//	
	//	// Enable Single Monitor Flag
	//	bool ENABLED = true;
	//	//cout << "//mlbertmgr_enableMonitorFlag status:" << //mlbertmgr_enableMonitorFlag(MLBERT, SINGLEMONITORFLAG, ENABLED) << endl;
	//	_sleep(350);
	//	// Single Read Monitor Flag
	//	cout << "mlbertmgr_singleReadMonitor status:" << mlbertmgr_singleReadMonitor(MLBERT, SINGLEMONITORFLAG, SINGLE_MONITOR) << endl;
	//	cout << "temperature: " << SINGLE_MONITOR[0] << " " << SINGLE_MONITOR[1] << " " << SINGLE_MONITOR[2] << " " << SINGLE_MONITOR[3] << endl;
	//	//Disable Single Monitor Flag
	//	ENABLED = false;
	//	//cout << "//mlbertmgr_enableMonitorFlag status:" << //mlbertmgr_enableMonitorFlag(MLBERT, SINGLEMONITORFLAG, ENABLED) << endl;
	//
	//	// Second method : MultiRead monitor flags
	//	// Refer to MONITOR_FLAGS Enum for bits order.Set to 1023 to enable all monitor flags
	//	int MULTIMONITORFLAGS = 1023;
	//	// Monitor multiple Flags(e.g 200) following the same order of the MONITOR_FLAGS Enum
	//	ushort MULTI_MONITOR[400];
	//	// Enable Multi Monitor Flags
	//	cout << "mlbertmgr_enableMonitor status : " << mlbertmgr_enableMonitor(MLBERT, MULTIMONITORFLAGS) << endl;
	//	// Wait for Monitor Accumulation.
	//	_sleep(350);
	//	// Multi - Read Monitor
	//	//cout << "mlbertmgr_multiReadMonitor status: " << mlbertmgr_multiReadMonitor(MLBERT, MULTIMONITORFLAGS, MULTI_MONITOR) << endl;
	//	// Disable Monitor Flags
	//	//MULTIMONITORFLAGS = 0;
	//	//cout << "mlbertmgr_enableMonitor status: " << mlbertmgr_enableMonitor(MLBERT, MULTIMONITORFLAGS) << endl;
	//
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
		//Test Flow 8: Execute fundamental BER Test
	
		//Pre-allocate MEASBERDATA Struct
		MeasurementsData* MEASBERDATA = new MeasurementsData[1024];
		int DATACOUNT = 0;
		const int NB_BER_CHANNELS = 8;
	
		// Enable BER Data Accumulation. Otherwise, the latest Data is captured
		bool ACCUMULATE = true;
		// BER Enbaled CHANNELS. First Channel is Enabled
		ushort BERENABLEDCH = 0xff;
		ushort VALUE[NB_BER_CHANNELS] = { 0 };
	
		// Before starting the BER accumulation, it is recommended to add a settling time of 2 seconds
		// ML4054B requires 5 seconds after the configuration
		// "pymlbertmgr.getConfigStatus()" will be implemented in a future library release to check the instrument configuration status and avoid adding a sleep time in the application script
		//_sleep(5000);  //  For ML4079EN use 10000
	
		// Initialize Rx Lock Status and Monitor Rx Lock Status
		// Single Read Monitor of Rx Lock Status
		//SINGLEMONITORFLAG = BERTMGR_MONITOR_RXLOCK;
		//cout << "mlbertmgr_enableMonitor status: " << //mlbertmgr_enableMonitorFlag(MLBERT, SINGLEMONITORFLAG, true) << endl;
		_sleep(350);
	
		// Call Rx lock Status in a while loop
	
		//for (int channel = 0; channel < NB_BER_CHANNELS; channel++) {
		//	int RETRY = 10;
		//	while (VALUE[channel] == 0 && RETRY > 0) {
		//		mlbertmgr_singleReadMonitor(MLBERT, SINGLEMONITORFLAG, VALUE);
		//		// check rx lock every 100 ms
		//		_sleep(100);
		//		RETRY -= 1;
		//	}
		//	if (VALUE[channel] == 1) { cout << "channel " << channel + 1 << " is locked" << endl; }
		//	else { cout << "channel " << channel + 1 << " is not locked" << endl; }
		//}
	
		//cout << "mlbertmgr_enableMonitor status: " << //mlbertmgr_enableMonitorFlag(MLBERT, SINGLEMONITORFLAG, false) << endl;
	
		// Start BER. This function requires Rx Lock.
		mlbertmgr_startBER(MLBERT, BERENABLEDCH, ACCUMULATE);
		// BER Counting Time
		// ML4054 BER Accumulation starts 4 seconds after enabling the BER process.
		// BER counting time
		_sleep(10000);
	
		//Get Available Data
		cout << "mlbertmgr_getAvailableBERData status: " << mlbertmgr_getAvailableBERData(MLBERT, MEASBERDATA, DATACOUNT) << endl;
		//print Out BER Data. Check MeasurementsData struct for more details
		cout << "Datacount: " << DATACOUNT << endl;
		cout << "Measured BER Data : " << endl;
		cout << "\tIs BER Enabled : " << MEASBERDATA[DATACOUNT - 1].berData.enabled << endl;
		for (int channel = 0; channel < NB_CHANNELS; channel++) {
			cout << "\nchannel " << channel + 1 << endl;
			cout << "\tEnabled Channels : " << MEASBERDATA[DATACOUNT - 1].berData.enabledChannels[channel] << endl;
			cout << "\tLocked Channels : " << MEASBERDATA[DATACOUNT - 1].berData.lockedChannels[channel] << endl;
			cout << "\tBER Capture Time : " << MEASBERDATA[DATACOUNT - 1].berData.Time[channel] << endl;
			cout << "\tBit Count : " << MEASBERDATA[DATACOUNT - 1].berData.BitCount[channel] << endl;
			cout << "\tErrorCount_MSB: " << MEASBERDATA[DATACOUNT - 1].berData.ErrorCount_MSB[channel] << endl;
			cout << "\tErrorCount_LSB: " << MEASBERDATA[DATACOUNT - 1].berData.ErrorCount_LSB[channel] << endl;
			cout << "\tErrorCount : " << MEASBERDATA[DATACOUNT - 1].berData.ErrorCount[channel] << endl;
			cout << "\tAccumulatedErrorCount_MSB: " << MEASBERDATA[DATACOUNT - 1].berData.AccumulatedErrorCount_MSB[channel] << endl;
			cout << "\tBER_MSB_Interval: " << MEASBERDATA[DATACOUNT - 1].berData.BER_MSB_Interval[channel] << endl;
			cout << "\tBER_MSB_Realtime: " << MEASBERDATA[DATACOUNT - 1].berData.BER_MSB_Realtime[channel] << endl;
			cout << "\tAccumulatedErrorCount_LSB: " << MEASBERDATA[DATACOUNT - 1].berData.AccumulatedErrorCount_LSB[channel] << endl;
			cout << "\tBER_LSB_Interval: " << MEASBERDATA[DATACOUNT - 1].berData.BER_LSB_Interval[channel] << endl;
			cout << "\tBER_LSB_Realtime: " << MEASBERDATA[DATACOUNT - 1].berData.AccumulatedErrorCount_LSB[channel] << endl;
			cout << "\tAccumulatedErrorCount  : " << MEASBERDATA[DATACOUNT - 1].berData.AccumulatedErrorCount[channel] << endl;
			cout << "\tBER_Interval: " << MEASBERDATA[DATACOUNT - 1].berData.BER_Interval[channel] << endl;
			cout << "\tBER Realtime : " << MEASBERDATA[DATACOUNT - 1].berData.BER_Realtime[channel] << endl;
		}
	
		//Stop BER 
		cout << "mlbertmgr_stopBER status: " << mlbertmgr_stopBER(MLBERT) << endl;
		
		BERTMGR_MONITOR_FLAGS SINGLEMONITORFLAG = BERTMGR_MONITOR_SNR;


		mlbertmgr_enableMonitor(MLBERT, SINGLEMONITORFLAG);

		ushort values[8];

		mlbertmgr_singleReadMonitor(MLBERT, SINGLEMONITORFLAG, values);
	


	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//// Test Flow 9: Read Histogram Data
	//
	////Edit parameters for your instance
	//	//Enabled channel flags(1 bit / channel)
	//	ushort  HISTENABLEDCHANNEL = 0x10;
	//
	//	HistogramData HIST[8];
	//	//Get Enabled Channels
	//	ushort ACTUAL_ENABLED = 0;
	//
	//	// blocking API call
	//	cout << "mlbertmgr_captureHistogramData status: " << mlbertmgr_getHistogramData(MLBERT, HISTENABLEDCHANNEL, HIST) << endl;
	//	
	//
	//	//mlbertmgr_enableMonitorFlag(MLBERT, BERTMGR_MONITOR_SNR, true);
	//	_sleep(200);
	//	ushort* _snrData = new ushort[8];
	//	mlbertmgr_singleReadMonitor(MLBERT, BERTMGR_MONITOR_SNR, _snrData);
	//
	//	for (int i = 0; i < 8; i++)
	//		cout << i << " " << _snrData[i] << endl;
	//
	//
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//Test Flow 10: FEC Mode
	//		FECMODE = BERTMGR_50G_KP4;
	//		FECPATTRN = BERTMGR_FECPATTERN_IDLE;
	//	ushort CHANNELS = 0xff;
	//	bool SKIPRESET = false;
	//	// Set FEC Mode.Check The table of features for compatibility
	//	cout << "mlbertmgr_setFECMode status: " << mlbertmgr_setFECMode(MLBERT, FECMODE, FECPATTRN, APPLYCONFIG) << endl;
	//	// Set FEC Mode.Check The table of features for compatibility
	//	//cout << "mlbertmgr_configureFECLinks status: " << mlbertmgr_configureFECLinks(MLBERT, CHANNELS, SKIPRESET, APPLYCONFIG) << endl;
	//
	//	_sleep(4000);
	//
	//	// Start BER. This function requires Rx Lock.
	//	mlbertmgr_startBER(MLBERT, BERENABLEDCH, ACCUMULATE);
	//	// BER Counting Time
	//	// ML4054 BER Accumulation starts 4 seconds after enabling the BER process.
	//	// BER counting time
	//	_sleep(4000);
	//
	//	//Get Available Data
	//	cout << "mlbertmgr_getAvailableBERData status: " << mlbertmgr_getAvailableBERData(MLBERT, MEASBERDATA, DATACOUNT) << endl;
	//	//print Out BER Data. Check MeasurementsData struct for more details
	//	cout << "Datacount: " << DATACOUNT << endl;
	//	cout << "Measured BER Data : " << endl;
	//	cout << "\tIs BER Enabled : " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.enabled << endl;
	//	for (int channel = 0; channel < NB_CHANNELS; channel++) {
	//		cout << "\nchannel " << channel + 1 << endl;
	//		cout << "\tenabled Links : " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.enabledLinks[channel] << endl;
	//		cout << "\tlocked Links : " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.lockedLinks[channel] << endl;
	//		cout << "\tBER Capture Time : " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.Time[channel] << endl;
	//		cout << "\tBit Count : " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.BitCount[channel] << endl;
	//		cout << "\tFEC Corrected Bit Count Interval: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.FEC_CorrectedBitCount_Interval[channel] << endl;
	//		cout << "\tFEC CW UnCorrected Count Interval: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.FEC_CW_UnCorrectedCount_Interval[channel] << endl;
	//		cout << "\tFEC CW Corrected Count Interval : " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.FEC_CW_CorrectedCount_Interval[channel] << endl;
	//		cout << "\tFEC CW Processed Count Interval: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.FEC_CW_ProcessedCount_Interval[channel] << endl;
	//		cout << "\tFEC CW Uncorrected Error Rate Interval: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.FEC_CW_UncorrectedErrorRate_Interval[channel] << endl;
	//		cout << "\tAccumulated FEC CW UnCorrected Count: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.AccumulatedFEC_CW_UnCorrectedCount[channel] << endl;
	//		cout << "\tAccumulated FEC CW Corrected Count: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.AccumulatedFEC_CW_CorrectedCount[channel] << endl;
	//		cout << "\tAccumulated FEC CW Processed Count: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.AccumulatedFEC_CW_ProcessedCount[channel] << endl;
	//		cout << "\tAccumulated FEC CW Uncorrected Error Rate: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.AccumulatedFEC_CW_UncorrectedErrorRate[channel] << endl;
	//		cout << "\t SER Instant SER: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.SER[channel].InstantSER << endl;
	//		cout << "\t SER Accumulated SER: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.SER[channel].AccumulatedSER[0] << endl;
	//		cout << "\t SER Instant SER: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.SER[channel].InstantSER[0] << endl;
	//		cout << "\tTotal Bit Count: " << MEASBERDATA[DATACOUNT - 1].realFecData_4044.TotalBitCount[channel] << endl;
	//	}
	//    //Stop BER 
	//    cout << "mlbertmgr_stopBER status: " << mlbertmgr_stopBER(MLBERT) << endl;
	//
	//    //////////////////////////////////////////////////////////////////////////////////////////////////////
	//    //Test Flow 11: Adapter Control Flow
	//
	//    // Detect Module Adapter Type 
	//    ADAPTER_TYPE ADAPTERTYPE;
	//    cout << "mlbertmgr_detectAdapter status: " << mlbertmgr_detectAdapter(MLBERT, &ADAPTERTYPE) << endl;
	//    cout << "Adapter Type = " << ADAPTERTYPE << endl;
	//
	//    // Set Adapter I2C Control Mode to Internal
	//    bool ISENABLED = false;
	//    cout << "mlbertmgr_setExternalAdapterMode status: " << mlbertmgr_setExternalAdapterMode(MLBERT, ISENABLED) << endl;
	//    cout << "External Adapter Mode set to: " << boolalpha << ISENABLED << endl;
	//
	//    // Control Adapter Pins
	//    bool STATUS = false;
	//    ADAPTER_HWSIGNAL_CNTRL AdapterContolePin = ADAPTER_HWSIGNAL_CNTRL_QDD_MODSEL_L;
	//    cout << "mlbertmgr_setControlPin status:  " << mlbertmgr_setControlPin(MLBERT, AdapterContolePin, STATUS) << endl;
	//
	//    //////////////////////////////////////////////////////////////////////////////////////////////////////
	//    //Test Flow 12: Tranceiver control Flow
	//    //SetTXOutputDisable
	//    CHANNEL = 0;
	//    STATUS = false;
	//
	//    //Transceiver TX Output Disable
	//    cout << "mltxvr_setTXOutputDisable status: " << mltxvr_setTxOutputDisable(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    // Transceiver DataPathDeInit Configuration.
	//    cout << "mltxvr_setTXDataPathDeInit status: " << mltxvr_setTxDataPathDeInit(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    // Transceiver TX Squelch Disable Configuration.
	//    cout << "mltxvr_setTXSquelchDisable status: " << mltxvr_setTxSquelchDisable(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    //Transceiver TX Force Squelch Configuration.
	//    cout << "mltxvr_setTXForceSquelch status: " << mltxvr_setTxForceSquelch(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    //Transceiver TX Polarity Flip Configuration.
	//    cout << "mltxvr_setTXPolarityFlip status: " << mltxvr_setTxPolarityFlip(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    // Transceiver TX input equalization
	//    // CMIS Range is from 0 - 12.
	//    int I_VALUE = 0;
	//    cout << "mltxvr_setTXInputEqualization status: " << mltxvr_setTxInputEqualization(MLBERT, CHANNEL, I_VALUE) << endl;
	//
	//    //Transceiver RX Controls
	//    STATUS = false;
	//    // Transceiver Rx Polarity Flip
	//    cout << "mltxvr_setRXPolarityFlip status: " << mltxvr_setRxPolarityFlip(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    // Transceiver RX Squelch Disable Configuration.
	//    cout << "mltxvr_setRXSquelchDisable status: " << mltxvr_setRxSquelchDisable(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    //Transceiver RX Output Disable Configuration.
	//    cout << "mltxvr_setRXOutputDisable status: " << mltxvr_setRxOutputDisable(MLBERT, CHANNEL, STATUS) << endl;
	//
	//    // Transceiver RX Output Pre - Cursor.
	//    // CMIS Range from 0 - 7
	//    I_VALUE = 1;
	//    cout << "mltxvr_setRXPreCursor status: " << mltxvr_setRxPreCursor(MLBERT, CHANNEL, I_VALUE) << endl;
	//
	//    // Transceiver RX Output Post - Cursor.
	//    // Range from 0 - 7
	//    cout << "mltxvr_setRXPostCursor status: " << mltxvr_setRxPostCursor(MLBERT, CHANNEL, I_VALUE) << endl;
	//
	//    // Transceiver RX Output Amplitude.
	//    TXVR_RX_AMPLITUDE TRANS_RX_AMPLITUDE = TXVR_RX_AMPLITUDE_100_400;
	//    cout << "mltxvr_setRXAmplitude status: " << mltxvr_setRxAmplitude(MLBERT, CHANNEL, TRANS_RX_AMPLITUDE) << endl;
	//
	//    TXVR_ConfigurationSettings TRANS_ACTIVECONFIG;
	//    int TRANS_NB_CHANNEL = 8;
	//    cout << "mltxvr_getActiveConfig status: " << mltxvr_getActiveConfig(MLBERT, &TRANS_ACTIVECONFIG) << endl;
	//    for (int channel = 0; channel < TRANS_NB_CHANNEL; channel++) {
	//        cout << "channel: " << channel + 1 << endl;
	//        cout << "\tDataPathDeInit: " << TRANS_ACTIVECONFIG.DataPathDeInit[channel] << endl;
	//        cout << "\tTXOuputDisable: " << TRANS_ACTIVECONFIG.TXOuputDisable[channel] << endl;
	//        cout << "\tTXPolarityFlip: " << TRANS_ACTIVECONFIG.TXPolarityFlip[channel] << endl;
	//        cout << "\tTXSquelchDisable: " << TRANS_ACTIVECONFIG.TXSquelchDisable[channel] << endl;
	//        cout << "\tTXForceSquelch: " << TRANS_ACTIVECONFIG.TXForceSquelch[channel] << endl;
	//        cout << "\tTXEqualization: " << unsigned(TRANS_ACTIVECONFIG.TXEqualization[channel]) << endl;
	//        cout << "\tRXOutputDisable: " << TRANS_ACTIVECONFIG.RXOutputDisable[channel] << endl;
	//        cout << "\tRXPolarityFlip: " << TRANS_ACTIVECONFIG.RXPolarityFlip[channel] << endl;
	//        cout << "\tRXSquelchDisable: " << TRANS_ACTIVECONFIG.RXSquelchDisable[channel] << endl;
	//        cout << "\tRXOutputAmplitude: " << TRANS_ACTIVECONFIG.RXOutputAmplitude[channel] << endl;
	//        cout << "\tRXOutputPreCursor: " << unsigned(TRANS_ACTIVECONFIG.RXOutputPreCursor[channel]) << endl;
	//        cout << "\tRXOutputPostCursor: " << unsigned(TRANS_ACTIVECONFIG.RXOutputPostCursor[channel]) << endl;
	//
	//    }
	//    //  Reads Transceiver MSA values
	//    const int NB_PAGES = 7;
	//    TXVR_MSA_PAGE MSAPAGES[NB_PAGES] = {
	//        TXVR_MSA_PAGE_LOWERMEMORY,
	//        TXVR_MSA_PAGE_0 ,
	//        TXVR_MSA_PAGE_1,
	//        TXVR_MSA_PAGE_2,
	//        TXVR_MSA_PAGE_3,
	//        TXVR_MSA_PAGE_16,
	//        TXVR_MSA_PAGE_17 };
	//    ushort MSAVALUES[128 * NB_PAGES];
	//    cout << "mltxvr_getMSAValues status: " << mltxvr_getMSAValues(MLBERT, MSAPAGES, MSAVALUES, NB_PAGES) << endl;
	//
	//    //Sequential MSA Read
	//    //Register addresse range is 128->255, Except LOWERMEMORY where the addresse range is 0->127
	//    //LOWERMEMORY page index is 0
	//    ushort READING_PAGE_SELECT = 0;
	//    ushort READING_REGISTER_ADDRESS = 128;
	//    const ushort READING_DATA_LENGTH = 128;
	//    ushort READING_DATA_BUFFER[READING_DATA_LENGTH];
	//    cout << "mltxvr_sequentialRead status: " << mltxvr_sequentialRead(MLBERT, READING_PAGE_SELECT, READING_REGISTER_ADDRESS, READING_DATA_LENGTH, READING_DATA_BUFFER, READING_PAGE_SELECT) << endl;
	//
	//    //Sequential MSA Write
	//    ushort WRITING_PAGE_SELECT = 0;
	//    ushort WRITING_REGISTER_ADDRESS = 0;
	//    const ushort WRITING_DATA_LENGTH = 128;
	//    ushort WRITING_DATA_BUFFER[READING_DATA_LENGTH];
	//    ushort WRITING_BANK_SELECT = 0;
	//    cout << "mltxvr_sequentialWrite status: " << mltxvr_sequentialWrite(MLBERT, WRITING_PAGE_SELECT, WRITING_REGISTER_ADDRESS, WRITING_DATA_LENGTH, WRITING_DATA_BUFFER, WRITING_BANK_SELECT) << endl;
	//
	//
	//
	//    //////////////////////////////////////////////////////////////////////////////////////////////////////
	//    //Test Flow 13: Adapter And Transceiver Monitor Flow
	//
	//    // Enable Adapter Monitor Flag
	//	BERTMGR_MONITOR_FLAGS MONITORFLAG = BERTMGR_MONITOR_ADAPTER;
	//    //Monitor Adapter requires 26 ushort values
	//    ushort ADAPTER_MONITOR_VALUES[26];
	//
	//    ENABLED = true;
	//    //cout << "//mlbertmgr_enableMonitorFlag status: " << //mlbertmgr_enableMonitorFlag(MLBERT, MONITORFLAG, ENABLED) << endl;
	//    // Wait for Monitor Accumulation
	//    _sleep(350);
	//    // Single - Read Monitor
	//    cout << "mlbertmgr_singleReadMonitor status: " << mlbertmgr_singleReadMonitor(MLBERT, MONITORFLAG, ADAPTER_MONITOR_VALUES) << endl;
	//    // Disable Monitor
	//    ENABLED = false;//spelling python
	//    //cout << "//mlbertmgr_enableMonitorFlag status: " << //mlbertmgr_enableMonitorFlag(MLBERT, MONITORFLAG, ENABLED) << endl;
	//
	//    // Print Out Adapter Monitor Values.Voltage values must be converted by dividing by 256
	//    cout << "VCC =  " << setprecision(3) << (double)ADAPTER_MONITOR_VALUES[0] / 256 << "V" << endl;
	//    cout << "VCC1 =  " << setprecision(3) << (double)ADAPTER_MONITOR_VALUES[1] / 256 << "V" << endl;
	//    cout << "VCC-TX =  " << setprecision(3) << (double)ADAPTER_MONITOR_VALUES[2] / 256 << "V" << endl;
	//    cout << "VCC-RX =  " << setprecision(3) << (double)ADAPTER_MONITOR_VALUES[3] / 256 << "V" << endl;
	//    cout << "VOLTAGE5 =  " << ADAPTER_MONITOR_VALUES[4] << "V" << endl;
	//    cout << "VOLTAGE6 =  " << ADAPTER_MONITOR_VALUES[5] << "V" << endl;
	//    cout << "VOLTAGE7 =  " << ADAPTER_MONITOR_VALUES[6] << "V" << endl;
	//    cout << "VOLTAGE8 =  " << ADAPTER_MONITOR_VALUES[7] << "V" << endl;
	//    cout << "I-VCC  =  " << ADAPTER_MONITOR_VALUES[8] << "mA" << endl;
	//    cout << "I-VCC1  =  " << ADAPTER_MONITOR_VALUES[9] << "mA" << endl;
	//    cout << "I-VCC-TX  =  " << ADAPTER_MONITOR_VALUES[10] << "mA" << endl;
	//    cout << "I-VCC-RX  =  " << ADAPTER_MONITOR_VALUES[11] << "mA" << endl;
	//    cout << "CURRENT5 =  " << ADAPTER_MONITOR_VALUES[12] << "mA" << endl;
	//    cout << "CURRENT6 =  " << ADAPTER_MONITOR_VALUES[13] << "mA" << endl;
	//    cout << "CURRENT7 =  " << ADAPTER_MONITOR_VALUES[14] << "mA" << endl;
	//    cout << "CURRENT8 =  " << ADAPTER_MONITOR_VALUES[15] << "mA" << endl;
	//    cout << "Temp1 =  " << ADAPTER_MONITOR_VALUES[16] << endl;
	//    cout << "Temp2 =  " << ADAPTER_MONITOR_VALUES[17] << endl;
	//    cout << "Temp3 =  " << ADAPTER_MONITOR_VALUES[18] << endl;
	//    cout << "Temp4 =  " << ADAPTER_MONITOR_VALUES[19] << endl;
	//    cout << "Temp5 =  " << ADAPTER_MONITOR_VALUES[20] << endl;
	//    cout << "Temp6 =  " << ADAPTER_MONITOR_VALUES[21] << endl;
	//    cout << "Temp7 =  " << ADAPTER_MONITOR_VALUES[22] << endl;
	//    cout << "Temp8 =  " << ADAPTER_MONITOR_VALUES[23] << endl;
	//
	//    cout << "Control Signals: " << endl;
	//    // Read back control Pins Status
	//    if ((ADAPTER_MONITOR_VALUES[24] & 1 << 0) == 1 << 0)
	//        cout << "\tModeSetL is enabled" << endl;
	//
	//    else cout << "\tModeSetL is disabled" << endl;
	//
	//    if ((ADAPTER_MONITOR_VALUES[24] & (1 << 1)) == 1 << 1)
	//        cout << "\tResetL is enabled" << endl;
	//
	//    else  cout << "\tResetL is disabled" << endl;
	//
	//    if ((ADAPTER_MONITOR_VALUES[24] & 1 << 2) == 1 << 2)
	//        cout << "\tLPMode is enabled" << endl;
	//
	//    else  cout << "\tLPMode is disabled" << endl;
	//    cout << "RO Signals: " << endl;
	//
	//    //Active Low
	//    if ((ADAPTER_MONITOR_VALUES[24] & 1 << 3) != 1 << 3)
	//        cout << "\tModePrsL is active" << endl;
	//
	//    else cout << "\tModePrsL is deactive" << endl;
	//
	//    //Active Low
	//    if ((ADAPTER_MONITOR_VALUES[24] & 1 << 4) != 1 << 4)
	//        cout << "\tIntL is active" << endl;
	//
	//    else cout << "\tIntL is deactive" << endl;
	//    cout << "Adapter IsExternalMode:  " << ADAPTER_MONITOR_VALUES[25] << endl;
	//
	//    // Enable Transceiver Monitor Flag
	//    MONITORFLAG = BERTMGR_MONITOR_TRANSCEIVER;
	//    // Monitor Transceiver requires ushort values.
	//    ushort TRANS_MONITOR_VALUES[80];
	//    ENABLED = true;
	//    //cout << "//mlbertmgr_enableMonitorFlag status: " << //mlbertmgr_enableMonitorFlag(MLBERT, MONITORFLAG, ENABLED) << endl;
	//
	//    //# Wait for Monitor Accumulation
	//    _sleep(350);
	//
	//    // Single - Read Monitor
	//    cout << "mlbertmgr_singleReadMonitor status: " << mlbertmgr_singleReadMonitor(MLBERT, MONITORFLAG, TRANS_MONITOR_VALUES) << endl;
	//    //# Disable Transceiver Monitor Flag
	//    ENABLED = false; //check python spelling 
	//    //cout << "//mlbertmgr_enableMonitorFlag status: " << //mlbertmgr_enableMonitorFlag(MLBERT, MONITORFLAG, ENABLED) << endl;
	//
	//    //Conversion is Performed According to CMIS Standard
	//    cout << "tempSupplyFlags:  " << TRANS_MONITOR_VALUES[0] << endl;
	//    cout << "aux1Aux2Flags:  " << TRANS_MONITOR_VALUES[1] << endl;
	//    cout << "aux3VendorFlags:  " << TRANS_MONITOR_VALUES[2] << endl;
	//    cout << "Temp1:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[3] / 256 << endl;
	//    cout << "Temp2:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[4] / 256 << endl;
	//    cout << "Temp3:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[5] / 256 << endl;
	//    cout << "Temp4:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[6] / 256 << endl;
	//    cout << "VCC:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[7] / 10000 << "V" << endl;
	//    cout << "VCC2:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[8] / 10000 << "V" << endl;
	//    cout << "VCC3:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[9] / 10000 << "V" << endl;
	//    cout << "VCC4:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[10] / 10000 << "V" << endl;
	//    cout << "aux1:  " << TRANS_MONITOR_VALUES[11] << endl;
	//    cout << "aux2:  " << TRANS_MONITOR_VALUES[12] << endl;
	//    cout << "aux3:  " << TRANS_MONITOR_VALUES[13] << endl;
	//    cout << "STATE_CHANGE:  " << TRANS_MONITOR_VALUES[14] << endl;
	//    cout << "TX_FAULT:  " << TRANS_MONITOR_VALUES[15] << endl;
	//    cout << "TX_LOS:  " << TRANS_MONITOR_VALUES[16] << endl;
	//    cout << "TX_LOL:  " << TRANS_MONITOR_VALUES[17] << endl;
	//    cout << "TXPOWER_HA:  " << TRANS_MONITOR_VALUES[18] << endl;
	//    cout << "TXPOWER_LA:  " << TRANS_MONITOR_VALUES[19] << endl;
	//    cout << "TXPOWER_HW:  " << TRANS_MONITOR_VALUES[20] << endl;
	//    cout << "TXPOWER_LW:  " << TRANS_MONITOR_VALUES[21] << endl;
	//    cout << "TXBIAS_HA:  " << TRANS_MONITOR_VALUES[22] << endl;
	//    cout << "TXBIAS_LA:  " << TRANS_MONITOR_VALUES[23] << endl;
	//    cout << "TXBIAS_HW:  " << TRANS_MONITOR_VALUES[24] << endl;
	//    cout << "TXBIAS_LW:  " << TRANS_MONITOR_VALUES[25] << endl;
	//    cout << "RX_LOS:  " << TRANS_MONITOR_VALUES[26] << endl;
	//    cout << "RX_LOL:  " << TRANS_MONITOR_VALUES[27] << endl;
	//    cout << "RXPOWER_HA:  " << TRANS_MONITOR_VALUES[28] << endl;
	//    cout << "RXPOWER_LA:  " << TRANS_MONITOR_VALUES[29] << endl;
	//    cout << "RXPOWER_LW:  " << TRANS_MONITOR_VALUES[30] << endl;
	//    cout << "RXPOWER_LW:  " << TRANS_MONITOR_VALUES[31] << endl;
	//    cout << "TX0:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[32] / 10000 << "mW" << endl;
	//    cout << "TX1:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[33] / 10000 << "mW" << endl;
	//    cout << "TX2:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[34] / 10000 << "mW" << endl;
	//    cout << "TX3:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[35] / 10000 << "mW" << endl;
	//    cout << "TX4:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[36] / 10000 << "mW" << endl;
	//    cout << "TX5:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[37] / 10000 << "mW" << endl;
	//    cout << "TX6:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[38] / 10000 << "mW" << endl;
	//    cout << "TX7:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[39] / 10000 << "mW" << endl;
	//    cout << "TX8:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[40] / 10000 << "mW" << endl;
	//    cout << "TX9:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[41] / 10000 << "mW" << endl;
	//    cout << "TX10:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[42] / 10000 << "mW" << endl;
	//    cout << "TX11:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[43] / 10000 << "mW" << endl;
	//    cout << "TX12:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[44] / 10000 << "mW" << endl;
	//    cout << "TX13:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[45] / 10000 << "mW" << endl;
	//    cout << "TX14:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[46] / 10000 << "mW" << endl;
	//    cout << "TX15:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[47] / 10000 << "mW" << endl;
	//    cout << "TX-Bias0:  " << TRANS_MONITOR_VALUES[48] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias1:  " << TRANS_MONITOR_VALUES[49] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias2:  " << TRANS_MONITOR_VALUES[50] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias3:  " << TRANS_MONITOR_VALUES[51] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias4:  " << TRANS_MONITOR_VALUES[52] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias5:  " << TRANS_MONITOR_VALUES[53] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias6:  " << TRANS_MONITOR_VALUES[54] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias7:  " << TRANS_MONITOR_VALUES[55] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias8:  " << TRANS_MONITOR_VALUES[56] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias9:  " << TRANS_MONITOR_VALUES[57] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias10:  " << TRANS_MONITOR_VALUES[58] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias11:  " << TRANS_MONITOR_VALUES[59] * 0.002 << "mA" << endl;
	//    cout << "TX-Bias12:  " << TRANS_MONITOR_VALUES[60] * 0.002 << " mA" << endl;
	//    cout << "TX-Bias13:  " << TRANS_MONITOR_VALUES[61] * 0.002 << " mA" << endl;
	//    cout << "TX-Bias14:  " << TRANS_MONITOR_VALUES[62] * 0.002 << " mA" << endl;
	//    cout << "TX-Bias15:  " << TRANS_MONITOR_VALUES[63] * 0.002 << " mA" << endl;
	//    cout << "RX0:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[64] / 10000 << "mW" << endl;
	//    cout << "RX1:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[65] / 10000 << "mW" << endl;
	//    cout << "RX2:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[66] / 10000 << "mW" << endl;
	//    cout << "RX3:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[67] / 10000 << "mW" << endl;
	//    cout << "RX4:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[68] / 10000 << "mW" << endl;
	//    cout << "RX5:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[69] / 10000 << "mW" << endl;
	//    cout << "RX6:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[70] / 10000 << "mW" << endl;
	//    cout << "RX7:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[71] / 10000 << "mW" << endl;
	//    cout << "RX8:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[72] / 10000 << "mW" << endl;
	//    cout << "RX9:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[73] / 10000 << "mW" << endl;
	//    cout << "RX10:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[74] / 10000 << "mW" << endl;
	//    cout << "RX11:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[75] / 10000 << "mW" << endl;
	//    cout << "RX12:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[76] / 10000 << "mW" << endl;
	//    cout << "RX13:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[77] / 10000 << "mW" << endl;
	//    cout << "RX14:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[78] / 10000 << "mW" << endl;
	//    cout << "RX15:  " << setprecision(3) << (double)TRANS_MONITOR_VALUES[79] / 10000 << "mW" << endl;
	//
	//
	//	//////////////////////////////////////////////////////////////////////////////////////////////////////
	//	//Test Flow 14:noise, PM, FM, AM flow
	//	bool ENBALED = true;
	//	//enable disable shallowLoopBack
	//	cout << "mlbertmgr_setShallowLoopback status " << mlbertmgr_setShallowLoopback(MLBERT, ENBALED, APPLYCONFIG) << endl;
	//
	//	//Noise configuration
	//	ENBALED = true;
	//	APPLYCONFIG = false;
	//	cout << "mlbertmgr_setNoiseStatus status " << mlbertmgr_setNoiseStatus(MLBERT, ENBALED, APPLYCONFIG) << endl;
	//
	//
	//	double NOISELINERATE = 25.78125;
	//	cout << "mlbertmgr_setNoiseLinerate status ", mlbertmgr_setNoiseLinerate(MLBERT, &NOISELINERATE, APPLYCONFIG);
	//
	//
	//	AMPLITUDE = 100;
	//	double BURSTRATE = 25.78125;
	//	double ACTUALRATE = 0;
	//	//Creates PatternConfig initial struct
	//	PatternConfig NOISETXPATTERN = PatternConfig();
	//	//Tx Pattern
	//	NOISETXPATTERN.pattern = BERTMGR_PRBS7;
	//	// Tx Invertion
	//	NOISETXPATTERN.invert = false;
	//	STATUS = true;
	//	bool isCalibrated = false;
	//
	//
	//	for (int channel = 0; channel < NB_CHANNELS; channel++) {
	//
	//		cout << "mlbertmgr_enableNoise status ", mlbertmgr_enableNoise(MLBERT, channel, STATUS, APPLYCONFIG);
	//
	//		if (isCalibrated)  //  Use this function if the noise amplitude is calibrated
	//		{
	//			int NOISEAMPLITUDEMV = 16;
	//			cout << "mlbertmgr_setNoiseAmplitude_mV status " << mlbertmgr_setNoiseAmplitude_mV(MLBERT, channel, NOISEAMPLITUDEMV, APPLYCONFIG) << endl;
	//		}
	//		else
	//		{
	//			cout << "mlbertmgr_setNoiseLevel status ", mlbertmgr_setNoiseLevel(MLBERT, channel, AMPLITUDE, APPLYCONFIG);
	//		}
	//
	//		cout << "mlbertmgr_setNoiseTxPattern status ", mlbertmgr_setNoiseTxPattern(MLBERT, channel, NOISETXPATTERN, APPLYCONFIG);
	//
	//		cout << "mlbertmgr_setNoiseBurstRate ", mlbertmgr_setNoiseBurstRate(MLBERT, channel, BURSTRATE, &ACTUALRATE, APPLYCONFIG);
	//		cout << "actual noise bert rate = " << ACTUALRATE << "channe" << channel << endl;
	//	}
	//
	//
	//	//PM configuration
	//	ushort PMPHASESHIFTAMPLITUDE = 1800;
	//	cout << "mlbertmgr_setPMPhaseShift status " << mlbertmgr_setPMPhaseShift(MLBERT, PMPHASESHIFTAMPLITUDE, APPLYCONFIG) << endl;
	//
	//	int PMFREQUENCY = 40; //PMFREQUENCY in KHz
	//	cout << "mlbertmgr_setPMFrequency status " << mlbertmgr_setPMFrequency(MLBERT, PMFREQUENCY, APPLYCONFIG) << endl;
	//
	//	STATUS = true;
	//	APPLYCONFIG = true;
	//	cout << "mlbertmgr_enablePM status "<< mlbertmgr_enablePMSJ(MLBERT, STATUS, APPLYCONFIG) << endl;
	//
	//	int PMAMPLITUDE = 20; //V
	//	cout << "mlbertmgr_setPMAmplitude status " << mlbertmgr_setPMSJAmplitude_ps(MLBERT, PMAMPLITUDE, APPLYCONFIG) << endl;
	//
	//	STATUS = true;
	//	cout << "mlbertmgr_enablePM RJ status " << mlbertmgr_enablePMRJ(MLBERT, STATUS, APPLYCONFIG) << endl;
	//
	//	int PMRJAMPLITUDE = 2050;
	//	cout << "mlbertmgr_setPMRJAmplitude status"<< mlbertmgr_setPMRJAmplitude(MLBERT, PMRJAMPLITUDE, APPLYCONFIG) << endl;
	//
	//	ushort PMPRBBSAMPLITUDE = 2050;
	//	cout << "mlbertmgr_setPMBUJAmplitude " << mlbertmgr_setPMBUJAmplitude(MLBERT, PMPRBBSAMPLITUDE, APPLYCONFIG) << endl;
	//
	//
	//	//FM configuration
	//	int FMPHASESHIFT = 665;
	//	cout << "mlbertmgr_setFMPhaseShift status " << mlbertmgr_setFMPhaseShift(MLBERT, FMPHASESHIFT, APPLYCONFIG) << endl;
	//
	//	int	FMFREQUENCY = 40;
	//	cout << "mlbertmgr_setFMFrequency status " << mlbertmgr_setFMFrequency(MLBERT, FMFREQUENCY, APPLYCONFIG) << endl;
	//
	//	STATUS = true;
	//	APPLYCONFIG = false;
	//	cout << "mlbertmgr_enableFM status " << mlbertmgr_enableFMSJ(MLBERT, STATUS, APPLYCONFIG) << endl;
	//
	//	int	FMRJAMPLITUDE = 22;
	//	cout << "mlbertmgr_setFMRJAmplitude status " << mlbertmgr_setFMSJAmplitude_ps(MLBERT, FMRJAMPLITUDE, APPLYCONFIG) << endl;
	//
	//	STATUS = true;
	//	cout << "mlbertmgr_enableFMRJ status " << mlbertmgr_enableFMRJ(MLBERT, STATUS, APPLYCONFIG) << endl;
	//
	//	FMRJAMPLITUDE = 22;
	//	cout << "mlbertmgr_setFMRJAmplitude status " << mlbertmgr_setFMRJAmplitude(MLBERT, FMRJAMPLITUDE, APPLYCONFIG) << endl;
	//
	//
	//    //////////////////////////////////////////////////////////////////////////////////////////////////////
	//    // Disconnect
	//    cout << "Close Connection status = " << mlbertmgr_closeConnection(MLBERT) << endl;
	//    cout << "Destroy Instance " << endl;
	//    mlbertmgr_destroyInstance(MLBERT);

	return 0;
}